/******************************************************************************
 *
 *  本文件声明了在消息列表界面的小圆圈（指示器）。
 *  小圆圈负责指示当前的网络状态，
 *  例如当前网络处于正在连接状态时，小圆圈开始转动，表示正在连接。当前连接成功/断开连接时，小圆圈停止转动，表示连接任务结束。
 *
 ******************************************************************************/

#import <UIKit/UIKit.h>

/**
 * 【模块名称】消息列表指示视图（TNaviBarIndicatorView）
 *
 * 【功能说明】负责根据当前的网络状态进行 UI 界面上的指示。
 *  当前网络状态为正在连接时，“小圆圈”开始转动，表示连接任务正在进行。
 *  连接成功或者无网络时，“小圆圈”停止转动且不可见，表示当前连接任务未在进行。
 *  同时还会根据当前网络状态，通过标签以文字的形式进行表现。
 */
@interface TNaviBarIndicatorView : UIView

/**
 *  指示器视图，即“小圆圈”本体。
 */
@property (nonatomic, strong) UIActivityIndicatorView *indicator;

/**
 *  示意标签
 *  除了通过“小圆圈”外，本试图还可通过文字形式对当前状态进行展示。
 *  例如：“连接中..." / ”腾讯·云通信（未连接）“等。
 */
@property (nonatomic, strong) UILabel *label;

/**
 *  设置标签
 *  通过本函数，您可以设置标签的内容，可以用于初始化标签或在合适的情况下修改标签内容。
 *
 *  @param title 需要设置的标签内容。
 */
- (void)setTitle:(NSString *)title;

/**
 *  开始转动
 *  令”小圆圈“开始转动。
 */
- (void)startAnimating;

/**
 *  停止转动
 *  令”小圆圈“停止转动。
 */
- (void)stopAnimating;
@end
